<?php

declare(strict_types=1);

namespace App\Services;

class HttpService
{
    public function get(string $url): array
    {
        $context = stream_context_create([
            'http' => [
                'timeout' => 30,
                'ignore_errors' => true,
            ],
            'ssl' => [
                'verify_peer' => true,
                'verify_peer_name' => true,
            ],
        ]);

        $response = @file_get_contents($url, false, $context);

        if ($response === false) {
            $error = error_get_last();
            return [
                'success' => false,
                'body' => null,
                'code' => 0,
                'error' => $error['message'] ?? 'Request failed',
            ];
        }

        $code = 200;
        if (isset($http_response_header[0]) && preg_match('/HTTP\/\d\.\d\s+(\d+)/', $http_response_header[0], $m)) {
            $code = (int) $m[1];
        }

        return [
            'success' => $code >= 200 && $code < 300,
            'body' => $response,
            'code' => $code,
            'decoded' => json_decode($response, true),
        ];
    }

    public function postJson(string $url, array $data): array
    {
        $payload = json_encode($data);
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'Content-Length: ' . strlen($payload)],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_MAXREDIRS => 5,
            CURLOPT_POSTREDIR => CURL_REDIR_POST_ALL,
        ]);

        $response = curl_exec($ch);
        $code = (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);

        if ($response === false) {
            return [
                'success' => false,
                'body' => null,
                'code' => $code ?: 0,
                'error' => $error ?: 'Request failed',
            ];
        }

        return [
            'success' => $code >= 200 && $code < 300,
            'body' => $response,
            'code' => $code,
            'decoded' => json_decode($response, true),
        ];
    }
}
