<?php

declare(strict_types=1);

namespace App\Models;

use PDO;

class CallbackEvent
{
    public function __construct(
        private PDO $pdo
    ) {}

    public function tryRecord(string $gameRound, string $callbackKey): bool
    {
        try {
            $stmt = $this->pdo->prepare('INSERT INTO callback_events (game_round, callback_key) VALUES (?, ?)');
            $stmt->execute([$gameRound, $callbackKey]);
            return true;
        } catch (\PDOException $e) {
            if ($e->getCode() == 23000) { // Duplicate key
                return false;
            }
            throw $e;
        }
    }
}
