<?php

declare(strict_types=1);

namespace App\Middleware;

use App\Models\Client;

class ValidateApiKey
{
    public function __construct(
        private Client $clientModel
    ) {}

    public function __invoke(string $apiKey): array
    {
        $apiKey = trim((string) $apiKey);
        if ($apiKey === '') {
            return ['valid' => false, 'error' => 'Missing api_key', 'client' => null];
        }

        $client = $this->clientModel->findByApiKey($apiKey);
        if ($client) {
            return ['valid' => true, 'error' => null, 'client' => $client];
        }
        $any = $this->clientModel->findByApiKeyAnyStatus($apiKey);
        $status = strtolower(trim((string) ($any['status'] ?? '')));
        if ($any && $status !== 'active') {
            return ['valid' => false, 'error' => 'api_key is inactive', 'client' => null];
        }
        return ['valid' => false, 'error' => 'Invalid api_key', 'client' => null];
    }
}
