# Client Server API - Integration Guide

This Client Server provides the same API surface as the main TM-API. Your customers integrate with this server using their API keys. All requests are forwarded to the main server internally.

---

## Quick Start

1. **Deploy** this client-server with your `MAIN_SERVER_URL`, `MAIN_SERVER_API_KEY`, and `PROXY_BASE_URL`.
2. **Run** `database/schema.sql` and `database/seed.sql` to create tables and admin user.
3. **Login** to `/admin` (default: password = `ADMIN_PASSWORD` from .env).
4. **Create clients** – each gets a unique API key (unlimited clients supported).
5. **Share** with your customers: API key, base URL (`PROXY_BASE_URL`), and integration docs.

---

## API Endpoints

### Launch Game

**GET or POST** `{PROXY_BASE_URL}/api/launch-game`

| Parameter     | Required | Description                     |
|---------------|----------|---------------------------------|
| `api_key`     | Yes      | Client's API key                |
| `user_id`     | Yes      | User identifier                 |
| `balance`     | Yes      | User's balance                  |
| `game_uid`    | Yes      | Game code (e.g. 6323, 7004)     |
| `return_url`  | No       | URL when user exits game        |
| `callback_url`| No       | URL for balance updates         |
| `currency_code`| No      | e.g. BDT, USD                   |
| `language`    | No       | e.g. en, bn                     |

**Success response:**
```json
{
    "code": 0,
    "msg": "Game launched successfully",
    "data": { "url": "https://..." }
}
```

Redirect the user to `data.url` to open the game.

### Callback (received by your customer's server)

When a bet/win is settled, we forward the callback to your customer's `callback_url`. They must return:

```json
{
    "credit_amount": 850,
    "timestamp": 1696329392000
}
```

---

## Configuration (.env)

| Variable           | Description                              |
|--------------------|------------------------------------------|
| `MAIN_SERVER_URL`  | Your main TM-API server URL              |
| `MAIN_SERVER_API_KEY` | API key from main server (one per client-server) |
| `PROXY_BASE_URL`   | This client-server's public URL          |
| `DB_*`             | Database connection                      |
| `ADMIN_PASSWORD`   | Admin panel password                     |

---

## Deployment

1. Copy `.env.example` to `.env` and fill values.
2. Import `database/schema.sql`, then `database/seed.sql`.
3. Set document root to `client-server/` or configure rewrite so `/api/*` and `/admin` route correctly.
4. On main server: create a client, whitelist this client-server's domain/IP, and use that API key as `MAIN_SERVER_API_KEY`.
5. Schedule cron: `php cron/retry_callbacks.php` (e.g. every minute) for failed callback retries.

---

*Client Server API – Last updated Feb 2026*
