<?php

declare(strict_types=1);

require_once __DIR__ . '/config/env.php';
require_once __DIR__ . '/autoload.php';

$pdo = require __DIR__ . '/config/connection.php';
$apiConfig = require __DIR__ . '/config/api.php';

$mainServer = $apiConfig['main_server'];
$proxy = $apiConfig['proxy'];

$clientModel = new \App\Models\Client($pdo);
$userModel = new \App\Models\User($pdo);
$gameSessionModel = new \App\Models\GameSession($pdo);
$transactionModel = new \App\Models\Transaction($pdo);
$callbackRetryModel = new \App\Models\CallbackRetry($pdo);
$callbackEventModel = new \App\Models\CallbackEvent($pdo);
$apiLogModel = new \App\Models\ApiLog($pdo);
$adminModel = new \App\Models\Admin($pdo);

$logger = new \App\Services\Logger($pdo);
$httpService = new \App\Services\HttpService();

$validateApiKey = new \App\Middleware\ValidateApiKey($clientModel);
$checkWhitelist = new \App\Middleware\CheckWhitelist();
$rateLimiter = new \App\Middleware\RateLimiter();
$forwardToMainServer = new \App\Middleware\ForwardToMainServer(
    $httpService,
    $mainServer['base_url'],
    $mainServer['api_key'],
    $proxy['base_url'],
    $mainServer['launch_path'],
);

$launchController = new \App\Controllers\LaunchGameController(
    $validateApiKey,
    $checkWhitelist,
    $rateLimiter,
    $forwardToMainServer,
    $gameSessionModel,
    $userModel,
    $logger,
    $proxy['base_url'],
);

$callbackController = new \App\Controllers\CallbackController(
    $pdo,
    $gameSessionModel,
    $transactionModel,
    $userModel,
    $clientModel,
    $callbackRetryModel,
    $callbackEventModel,
    $httpService,
    $logger,
);

return [
    'pdo' => $pdo,
    'admin' => $adminModel,
    'launch' => $launchController,
    'callback' => $callbackController,
    'client' => $clientModel,
    'user' => $userModel,
    'transaction' => $transactionModel,
    'apiLog' => $apiLogModel,
];
