<?php
$clientId = !empty($_GET['client_id']) ? (int) $_GET['client_id'] : null;
$dateFrom = trim($_GET['date_from'] ?? '');
$dateTo = trim($_GET['date_to'] ?? '');
$clients = $di['client']->findAll();
$page = max(0, (int) ($_GET['page'] ?? 0));
$limit = 50;
$offset = $page * $limit;
$txs = $di['transaction']->getList($clientId, $dateFrom ?: null, $dateTo ?: null, $limit, $offset);
$txStats = $di['transaction']->getStats($clientId ?? null);
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Transactions</h2>
</div>
<form method="get" class="mb-3 d-flex gap-2 flex-wrap align-items-end">
    <input type="hidden" name="p" value="transactions">
    <div><label class="form-label small">Client</label><select name="client_id" class="form-select form-select-sm bg-dark text-white" style="width:160px"><option value="">All</option><?php foreach ($clients as $c): ?><option value="<?= $c['id'] ?>" <?= $clientId === (int)$c['id'] ? 'selected' : '' ?>><?= htmlspecialchars($c['name']) ?></option><?php endforeach; ?></select></div>
    <div><label class="form-label small">From</label><input type="date" name="date_from" class="form-control form-control-sm bg-dark text-white" value="<?= htmlspecialchars($dateFrom) ?>"></div>
    <div><label class="form-label small">To</label><input type="date" name="date_to" class="form-control form-control-sm bg-dark text-white" value="<?= htmlspecialchars($dateTo) ?>"></div>
    <button type="submit" class="btn btn-sm btn-success">Filter</button>
</form>
<div class="row g-2 mb-3">
    <div class="col-auto"><span class="badge bg-secondary">Bets: <?= number_format($txStats['total_bets'], 2) ?></span></div>
    <div class="col-auto"><span class="badge bg-secondary">Wins: <?= number_format($txStats['total_wins'], 2) ?></span></div>
    <div class="col-auto"><span class="badge bg-success">Profit: <?= number_format($txStats['total_profit'], 2) ?></span></div>
</div>
<div class="card">
    <div class="table-responsive">
        <table class="table mb-0 table-sm">
            <thead><tr><th>ID</th><th>Client</th><th>User</th><th>Game Round</th><th>Bet</th><th>Win</th><th>Before</th><th>After</th><th>Commission</th><th>Date</th></tr></thead>
            <tbody>
                <?php foreach ($txs as $t): ?>
                <tr>
                    <td><?= (int) $t['id'] ?></td>
                    <td><?= htmlspecialchars($t['client_name'] ?? '') ?></td>
                    <td><code class="small"><?= htmlspecialchars($t['user_id']) ?></code></td>
                    <td><code class="small"><?= htmlspecialchars(substr($t['game_round'], 0, 20)) ?>...</code></td>
                    <td><?= number_format((float) $t['bet_amount'], 2) ?></td>
                    <td><?= number_format((float) $t['win_amount'], 2) ?></td>
                    <td><?= number_format((float) $t['before_balance'], 2) ?></td>
                    <td><?= number_format((float) $t['after_balance'], 2) ?></td>
                    <td><?= number_format((float) $t['commission_amount'], 2) ?></td>
                    <td class="small text-muted"><?= htmlspecialchars($t['created_at'] ?? '') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer border-secondary"><a href="?p=transactions&client_id=<?= $clientId ?? '' ?>&date_from=<?= urlencode($dateFrom) ?>&date_to=<?= urlencode($dateTo) ?>&page=<?= $page + 1 ?>" class="btn btn-sm btn-outline-secondary">Load more</a></div>
</div>
