<?php
$clients = $di['client']->findAll();
$clientProfits = [];
foreach ($clients as $c) {
    $s = $di['transaction']->getStats((int) $c['id']);
    $clientProfits[(int) $c['id']] = $s['total_profit'] ?? 0;
}
$editId = (int) ($_GET['edit'] ?? 0);
$edit = $editId ? $di['client']->getById($editId) : null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $act = $_POST['action'] ?? '';
    if ($act === 'create') {
        $apiKey = $di['client']->generateApiKey();
        $di['client']->create([
            'name' => $_POST['name'] ?? '',
            'api_key' => $apiKey,
            'status' => $_POST['status'] ?? 'active',
            'allowed_ips' => !empty($_POST['allowed_ips']) ? array_map('trim', explode("\n", $_POST['allowed_ips'])) : null,
            'allowed_domains' => !empty($_POST['allowed_domains']) ? array_map('trim', explode("\n", $_POST['allowed_domains'])) : null,
            'callback_url' => trim($_POST['callback_url'] ?? '') ?: null,
            'return_url' => trim($_POST['return_url'] ?? '') ?: null,
            'commission_percent' => (float) ($_POST['commission_percent'] ?? 0),
        ]);
        header('Location: ?p=clients&created=1');
        exit;
    }
    if ($act === 'update' && $editId) {
        $di['client']->update($editId, [
            'name' => $_POST['name'] ?? '',
            'api_key' => trim($_POST['api_key'] ?? ''),
            'status' => $_POST['status'] ?? 'active',
            'allowed_ips' => !empty($_POST['allowed_ips']) ? array_map('trim', explode("\n", $_POST['allowed_ips'])) : null,
            'allowed_domains' => !empty($_POST['allowed_domains']) ? array_map('trim', explode("\n", $_POST['allowed_domains'])) : null,
            'callback_url' => trim($_POST['callback_url'] ?? '') ?: null,
            'return_url' => trim($_POST['return_url'] ?? '') ?: null,
            'commission_percent' => (float) ($_POST['commission_percent'] ?? 0),
        ]);
        header('Location: ?p=clients&updated=1');
        exit;
    }
}
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Clients</h2>
    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#clientModal" onclick="document.getElementById('formAction').value='create'">+ Create Client</button>
</div>
<?php if (!empty($_GET['created'])): ?><div class="alert alert-success">Client created.</div><?php endif; ?>
<?php if (!empty($_GET['updated'])): ?><div class="alert alert-success">Client updated.</div><?php endif; ?>

<div class="card">
    <div class="table-responsive">
        <table class="table mb-0">
            <thead>
                <tr><th>ID</th><th>Name</th><th>API Key</th><th>Status</th><th>Commission</th><th>Balance</th><th>Profit</th><th>Actions</th></tr>
            </thead>
            <tbody>
                <?php foreach ($clients as $c): ?>
                <tr>
                    <td><?= (int) $c['id'] ?></td>
                    <td><?= htmlspecialchars($c['name']) ?></td>
                    <td><code class="small"><?= htmlspecialchars(substr($c['api_key'], 0, 16)) ?>...</code></td>
                    <td><span class="badge <?= $c['status'] === 'active' ? 'bg-success' : 'bg-secondary' ?>"><?= htmlspecialchars($c['status']) ?></span></td>
                    <td><?= number_format((float) $c['commission_percent'], 2) ?>%</td>
                    <td><?= number_format((float) $c['balance'], 2) ?></td>
                    <td class="text-success"><?= number_format($clientProfits[(int)$c['id']] ?? 0, 2) ?></td>
                    <td><a href="?p=clients&edit=<?= $c['id'] ?>" class="btn btn-sm btn-outline-secondary">Edit</a></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php if ($edit): ?>
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content bg-dark text-white border-secondary">
            <div class="modal-header border-secondary"><h5 class="modal-title">Edit Client</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
            <form method="post">
                <input type="hidden" name="action" value="update">
                <div class="modal-body">
                    <div class="mb-2"><label class="form-label">Name</label><input type="text" name="name" class="form-control bg-dark text-white" value="<?= htmlspecialchars($edit['name']) ?>"></div>
                    <div class="mb-2"><label class="form-label">API Key</label><input type="text" name="api_key" class="form-control bg-dark text-white font-monospace" value="<?= htmlspecialchars($edit['api_key']) ?>"></div>
                    <div class="mb-2"><label class="form-label">Status</label><select name="status" class="form-select bg-dark text-white"><option value="active" <?= $edit['status'] === 'active' ? 'selected' : '' ?>>Active</option><option value="inactive" <?= $edit['status'] === 'inactive' ? 'selected' : '' ?>>Inactive</option></select></div>
                    <div class="mb-2"><label class="form-label">Allowed IPs (one per line)</label><textarea name="allowed_ips" class="form-control bg-dark text-white" rows="2"><?= htmlspecialchars(implode("\n", $edit['allowed_ips'] ?? [])) ?></textarea></div>
                    <div class="mb-2"><label class="form-label">Allowed Domains (one per line)</label><textarea name="allowed_domains" class="form-control bg-dark text-white" rows="2"><?= htmlspecialchars(implode("\n", $edit['allowed_domains'] ?? [])) ?></textarea></div>
                    <div class="mb-2"><label class="form-label">Callback URL</label><input type="url" name="callback_url" class="form-control bg-dark text-white" value="<?= htmlspecialchars($edit['callback_url'] ?? '') ?>"></div>
                    <div class="mb-2"><label class="form-label">Return URL</label><input type="url" name="return_url" class="form-control bg-dark text-white" value="<?= htmlspecialchars($edit['return_url'] ?? '') ?>"></div>
                    <div class="mb-2"><label class="form-label">Commission %</label><input type="number" step="0.01" name="commission_percent" class="form-control bg-dark text-white" value="<?= htmlspecialchars((string) ($edit['commission_percent'] ?? 0)) ?>"></div>
                </div>
                <div class="modal-footer border-secondary"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button><button type="submit" class="btn btn-success">Update</button></div>
            </form>
        </div>
    </div>
</div>
<script>document.addEventListener('DOMContentLoaded', () => new bootstrap.Modal(document.getElementById('editModal')).show());</script>
<?php endif; ?>

<div class="modal fade" id="clientModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content bg-dark text-white border-secondary">
            <div class="modal-header border-secondary"><h5 class="modal-title">Create Client</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
            <form method="post">
                <input type="hidden" name="action" value="create">
                <div class="modal-body">
                    <div class="mb-2"><label class="form-label">Name</label><input type="text" name="name" class="form-control bg-dark text-white" required></div>
                    <div class="mb-2"><label class="form-label">Status</label><select name="status" class="form-select bg-dark text-white"><option value="active">Active</option><option value="inactive">Inactive</option></select></div>
                    <div class="mb-2"><label class="form-label">Allowed IPs (one per line, empty = all)</label><textarea name="allowed_ips" class="form-control bg-dark text-white" rows="2"></textarea></div>
                    <div class="mb-2"><label class="form-label">Allowed Domains (one per line, empty = all)</label><textarea name="allowed_domains" class="form-control bg-dark text-white" rows="2"></textarea></div>
                    <div class="mb-2"><label class="form-label">Callback URL</label><input type="url" name="callback_url" class="form-control bg-dark text-white"></div>
                    <div class="mb-2"><label class="form-label">Return URL</label><input type="url" name="return_url" class="form-control bg-dark text-white"></div>
                    <div class="mb-2"><label class="form-label">Commission %</label><input type="number" step="0.01" name="commission_percent" class="form-control bg-dark text-white" value="0"></div>
                    <p class="text-muted small">API key will be auto-generated after creation.</p>
                </div>
                <div class="modal-footer border-secondary"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button><button type="submit" class="btn btn-success">Create</button></div>
            </form>
        </div>
    </div>
</div>
