<?php

declare(strict_types=1);

session_start();
require_once dirname(__DIR__) . '/config/env.php';
require_once dirname(__DIR__) . '/autoload.php';

$di = require dirname(__DIR__) . '/bootstrap.php';

if (!isset($_SESSION['admin_logged']) || !$_SESSION['admin_logged']) {
    header('Location: /admin/login.php');
    exit;
}

$page = $_GET['p'] ?? 'dashboard';
$allowed = ['dashboard', 'clients', 'users', 'transactions', 'logs'];
if (!in_array($page, $allowed)) $page = 'dashboard';

$baseUrl = rtrim(getenv('PROXY_BASE_URL') ?: '', '/') ?: ('http' . (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 's' : '') . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost'));
$adminBase = $baseUrl . '/admin';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Client API Proxy Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root { --bg: #0f172a; --card: #111827; --accent: #22c55e; --text: #f1f5f9; --muted: #94a3b8; }
        body { background: var(--bg); color: var(--text); min-height: 100vh; }
        .sidebar { background: #0c1222; min-height: 100vh; padding: 1rem 0; }
        .sidebar .nav-link { color: var(--muted); padding: 0.75rem 1.5rem; border-radius: 0.5rem; margin: 0.25rem 0.5rem; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { color: var(--accent); background: rgba(34,197,94,0.1); }
        .card { background: var(--card); border: 1px solid #334155; border-radius: 0.75rem; }
        .card-header { background: transparent; border-bottom: 1px solid #334155; padding: 1rem 1.25rem; font-weight: 600; }
        .table { color: var(--text); }
        .table td, .table th { border-color: #334155; padding: 0.75rem; }
        .btn-success { background: var(--accent); border-color: var(--accent); }
        .btn-success:hover { background: #16a34a; border-color: #16a34a; }
        .badge-success { background: var(--accent); }
        .badge-inactive { background: #64748b; }
        .stat-card { padding: 1.25rem; }
        .stat-value { font-size: 1.75rem; font-weight: 700; color: var(--accent); }
        pre { background: #0c1222; padding: 1rem; border-radius: 0.5rem; font-size: 0.8rem; max-height: 200px; overflow: auto; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <nav class="col-md-2 sidebar">
                <div class="p-3">
                    <h5 class="text-white">Client API Proxy</h5>
                    <small class="text-muted">Admin Panel</small>
                </div>
                <ul class="nav flex-column">
                    <li class="nav-item"><a class="nav-link <?= $page === 'dashboard' ? 'active' : '' ?>" href="?p=dashboard">Dashboard</a></li>
                    <li class="nav-item"><a class="nav-link <?= $page === 'clients' ? 'active' : '' ?>" href="?p=clients">Clients</a></li>
                    <li class="nav-item"><a class="nav-link <?= $page === 'users' ? 'active' : '' ?>" href="?p=users">Users</a></li>
                    <li class="nav-item"><a class="nav-link <?= $page === 'transactions' ? 'active' : '' ?>" href="?p=transactions">Transactions</a></li>
                    <li class="nav-item"><a class="nav-link <?= $page === 'logs' ? 'active' : '' ?>" href="?p=logs">API Logs</a></li>
                </ul>
                <div class="mt-auto p-3"><a href="?logout=1" class="text-muted small">Logout</a></div>
            </nav>
            <main class="col-md-10 py-4">
                <?php
                if (isset($_GET['logout'])) { session_destroy(); header('Location: /admin/login.php'); exit; }
                include __DIR__ . '/pages/' . $page . '.php';
                ?>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
