# Client Server API Proxy

This is a proxy server that forwards all API requests to your main TM-API server. Deploy this for your clients so they can create unlimited API keys for their customers without direct access to the main provider.

## Architecture

- Your clients deploy this server and create sub-clients (their customers) via the admin panel.
- Each sub-client gets an API key.
- Sub-clients call this server's `/api/launch-game`; requests are forwarded to your main server.
- Callbacks flow: Main Server → This Server → Sub-client's callback URL.

## Deployment Checklist

Before handing to client, ensure:

1. **Copy `.env.example` to `.env`** and fill all values:
   - `MAIN_SERVER_URL` – Main API URL: https://api.bdt.techmazet.in
   - `MAIN_SERVER_API_KEY` – API key from your main server (create client in admin, whitelist this server)
   - `PROXY_BASE_URL` – Client-server's public URL (must be reachable by your main server for callbacks)
   - `DB_*` – Database credentials
   - `ADMIN_PASSWORD` – Admin panel password

2. **Main server setup:** Create a client in your admin, generate API key, add this client-server's domain/IP to whitelist.

3. **Run schema and seed:**
   ```bash
   mysql -u user -p database < database/schema.sql
   mysql -u user -p database < database/seed.sql
   ```

4. **Document root:** Point to this folder. Ensure `.htaccess` rewrites `/api/*` to `public/index.php` and `/admin` is excluded.

5. **Cron:** Schedule `php cron/retry_callbacks.php` every minute for failed callback retries.

6. **Test:** Login at `/admin/login.php` (admin/password), create a client, test launch-game.

7. **If you get 404:** Add `MAIN_SERVER_LAUNCH_PATH=/api/launch-game.php` to .env

8. **If you get "Invalid or inactive api_key":** See ENV_SETUP.md - MAIN_SERVER_API_KEY must match a client on main server

## Default Admin

- Username: `admin`
- Password: `password` (or leave username empty and use `ADMIN_PASSWORD` from .env)

Change the password after first login.
