# Client-Server Environment Setup

## Copy .env.example to .env and configure:

| Variable | Required | Where to get | Example |
|----------|----------|--------------|---------|
| DB_* | Yes | Your MySQL | localhost, root, client_server_proxy |
| MAIN_SERVER_URL | Yes | Main API domain | https://api.bdt.techmazet.in |
| MAIN_SERVER_API_KEY | Yes | Main server Admin > Clients | Create client, copy api_key |
| MAIN_SERVER_LAUNCH_PATH | No | Use if 404 | /api/launch-game.php |
| PROXY_BASE_URL | Yes | This server's URL | https://demo1.techmazet.in |
| ADMIN_PASSWORD | Yes | You choose | your_password |

## MAIN_SERVER_API_KEY - Critical

1. Login to **main server** admin (api.bdt.techmazet.in/admin)
2. Create a new client (or use existing)
3. Copy the **api_key**
4. Paste in client-server .env as MAIN_SERVER_API_KEY
5. On main server: edit that client, add this server's domain to Allowed Domains (or leave empty = allow all)

## "Invalid or inactive api_key" = MAIN_SERVER_API_KEY wrong

- Key must exist on main server
- Client must be Active
- Or IP/domain whitelist blocking (add client-server's domain/IP)
